unit [!UnitName];

interface

uses
  Borland.Eco.Handles,
  Borland.Eco.Web,
  [!EcoSpaceUnitName];

const
  // ToDo: Configure the strategy for the provider by changing the constant
  MODE: EcoSpaceStrategyHandler.SessionStateMode = EcoSpaceStrategyHandler.SessionStateMode.IfDirty;
   
type
  TEcoSpaceProvider = class
  public
		class function GetEcoSpace: [!EcoSpaceClassName]; static;
    class procedure ReturnEcoSpace(aEcoSpace: EcoSpace); static;
		class function GetSessionFreeEcoSpace: [!EcoSpaceClassName]; static;
    class procedure ReturnSessionFreeEcoSpace(aEcoSpace: EcoSpace); static;
    class procedure ClearSessionState; static;
  end;

implementation

// Utility methods

function GetHandler: EcoSpaceStrategyHandler;
begin
  Result := EcoSpaceStrategyHandler.Create(MODE, typeof([!EcoSpaceClassName]));
end;

{ TEcoSpaceProvider }

class procedure TEcoSpaceProvider.ClearSessionState;
begin
  GetHandler.ClearSessionState;
end;

class function TEcoSpaceProvider.GetEcoSpace(): [!EcoSpaceClassName];
begin
  Result := [!EcoSpaceClassName](GetHandler.GetEcoSpace);
end;

class procedure TEcoSpaceProvider.ReturnEcoSpace(aEcoSpace: EcoSpace);
begin
  GetHandler.ReturnEcoSpace(aEcoSpace);
end;

class function TEcoSpaceProvider.GetSessionFreeEcoSpace(): [!EcoSpaceClassName];
begin
  Result := [!EcoSpaceClassName](GetHandler.GetSessionFreeEcoSpace);
end;

class procedure TEcoSpaceProvider.ReturnSessionFreeEcoSpace(aEcoSpace: EcoSpace);
begin
  GetHandler.ReturnSessionFreeEcoSpace(aEcoSpace);
end;

end.
